# OllamaDeploy - Lokales KI-System auf dem Mac

Ein vollständiges Setup zur Einrichtung eines **privaten, lokalen KI-Servers** auf dem Mac mit Apple Silicon.

## 🎯 Projektübersicht

Dieses Projekt ermöglicht es dir, moderne Large Language Models (LLMs) wie **LLaMA**, **DeepSeek**, **Gemma** und **Mistral** komplett lokal auf deinem Mac zu betreiben - ohne Internet, ohne Cloud-Anbieter, mit voller Datenkontrolle.

### Vorteile

✅ **Privatsphäre** - Alle Daten bleiben auf deinem Mac
✅ **Offline-Betrieb** - Keine Internetverbindung erforderlich
✅ **Kostenlos** - Keine Abo-Gebühren wie bei ChatGPT
✅ **Flexibel** - Verschiedene KI-Modelle parallel nutzbar
✅ **Netzwerkfähig** - Zugriff von allen Geräten im lokalen Netzwerk

## 📋 Systemanforderungen

### Minimale Anforderungen
- **Mac mit Apple Silicon** (M1, M2, M3, M4)
- **16 GB RAM** (für Basismodelle)
- **50 GB freier SSD-Speicher** (für erste Modelle)
- **macOS 11 Big Sur oder neuer**

### Empfohlene Konfiguration
- **32-64 GB RAM** (für komplexere Modelle)
- **100+ GB freier SSD-Speicher**
- **M3/M4 Prozessor** (für beste Performance)

### RAM-Empfehlungen nach Nutzung

| RAM  | Geeignete Modelle | Anwendungsfälle |
|------|-------------------|-----------------|
| 8 GB | Nicht empfohlen | Nur Tests möglich |
| 16 GB | 7B-8B Parameter | Einfache Texte, Übersetzungen |
| 32 GB | 14B-32B Parameter | Programmierung, Analysen |
| 64 GB | 70B Parameter | Komplexe Aufgaben |
| 128+ GB | 671B Parameter | Professioneller Einsatz |

## 🚀 Schnellstart

### Methode 1: Interaktives Menü (Empfohlen) ⚡

```bash
# Klone das Repository
git clone https://github.com/cocoacastsplus/OllamaDeploy.git
cd OllamaDeploy

# Starte das interaktive Menü
./start.sh

# Nutze ↑/↓ Pfeiltasten zum Navigieren
# Wähle "Vollautomatische Installation"
```

**Das war's!** In 10 Minuten ist alles fertig installiert.

### Methode 2: Vollautomatische Installation (Direkt) ⚡

```bash
# Klone das Repository
git clone https://github.com/cocoacastsplus/OllamaDeploy.git
cd OllamaDeploy

# Vollautomatische Installation
./install.sh --auto

# Fertig! Öffne http://localhost:3000
```

### Methode 3: Interaktive Installation mit Rückfragen 🎯

```bash
# Mit Rückfragen und Optionen
./install.sh

# Oder manuell mit den Einzelskripten
./scripts/setup.sh
```

### Schnellzugriff auf alle Funktionen

```bash
# Interaktives Hauptmenü mit allen Optionen
./start.sh

# Verfügbare Menüpunkte:
# - Vollautomatische Installation
# - Interaktive Installation
# - Installation ohne Modell-Download
# - System verwalten
# - System aktualisieren
# - Open WebUI öffnen
# - Schnellstart-Guide
# - Deinstallation
```

### Deinstallation

```bash
# Alles sauber entfernen
./uninstall.sh

# Oder alles löschen ohne Rückfragen
./uninstall.sh --force
```

### 2. Erste Schritte

Nach der Installation:

1. **Öffne Open WebUI** im Browser: http://localhost:3000
2. **Erstelle einen Admin-Account**
3. **Wähle ein KI-Modell** aus der Liste
4. **Starte deinen ersten Chat!**

## 📦 Was wird installiert?

### 1. Ollama
Die Basis-Plattform für lokale LLMs
- Download: https://ollama.com
- Verwaltung der KI-Modelle
- Terminal-basierte Bedienung

### 2. Docker Desktop
Container-Platform für Open WebUI
- Download: https://docker.com/products/docker-desktop
- Isolation der Weboberfläche
- Einfache Verwaltung

### 3. Open WebUI
ChatGPT-ähnliche Weboberfläche
- Benutzerfreundliches Interface
- Benutzerverwaltung
- Dokumenten-Upload
- Modellvergleich

## 🧠 Verfügbare KI-Modelle

### LLaMA 3.1/3.3 (Meta)
```bash
# Kleine Version (8B Parameter, ~5 GB)
ollama pull llama3.1

# Große Version (70B Parameter, ~43 GB)
ollama pull llama3.3:70b
```

### DeepSeek-R1 (DeepSeek)
```bash
# Kompakt (7B Parameter, ~5 GB)
ollama pull deepseek-r1:7b

# Mittelgroß (32B Parameter, ~20 GB)
ollama pull deepseek-r1:32b

# Sehr groß (671B Parameter, ~404 GB)
ollama pull deepseek-r1:671b
```

### Gemma 3 (Google)
```bash
# Standard (12B Parameter)
ollama pull gemma3:12b
```

### Mistral (Mistral AI)
```bash
# Standard
ollama pull mistral
```

## ⚙️ Konfiguration

### System-Prompt anpassen

Unter **Einstellungen → Allgemein → System Prompt** kannst du das Verhalten der KI steuern:

```
Du bist ein Experte für [Thema]. Antworte kurz und präzise mit
technischen Details. Verwende eine formelle Ausdrucksweise.
```

### Wichtige Parameter

| Parameter | Zweck | Empfehlung |
|-----------|-------|------------|
| **Temperatur** | Kreativität vs. Präzision | 0.2-0.4 für Fakten, 0.8 für Kreatives |
| **Top K** | Wortauswahl-Pool | 40-100 für Balance |
| **Top P** | Wahrscheinlichkeitsschwelle | 0.9 (90%) Standard |
| **Kontextlänge** | Erinnerungsvermögen | 4096 für normale Chats |

### Halluzinationen vermeiden

1. **Niedrige Temperatur** (0.2-0.4)
2. **Präzise Prompts** verwenden
3. **Kontextuelle Hinweise** geben
4. **Dokumente hochladen** für Fakten

## 📁 Mit Dokumenten arbeiten

Open WebUI unterstützt:
- 📄 PDF-Dateien
- 📊 Excel/CSV-Tabellen
- 🖼️ Bilder (JPG, PNG)
- 📝 Text-Dateien

### Beispiele

```
"Fasse das hochgeladene PDF in 5 Stichpunkten zusammen"
"Analysiere die Tabelle und zeige mir die Trends"
"Was ist auf dem Bild zu sehen? Beschreibe Details."
```

## 🔧 Verwaltung

### Modelle auflisten
```bash
ollama list
```

### Modell entfernen
```bash
ollama rm llama3.2
```

### Modell im Terminal testen
```bash
ollama run llama3.1
# Mit /bye beenden
```

### Docker Container verwalten

```bash
# Container stoppen
docker stop open-webui

# Container starten
docker start open-webui

# Container neu starten
docker restart open-webui
```

## 🌐 Netzwerkzugriff

### Von anderen Geräten zugreifen

1. **Finde die IP deines Macs:**
```bash
hostname
# oder
ifconfig | grep "inet "
```

2. **Öffne im Browser eines anderen Geräts:**
```
http://[MAC-IP-ADRESSE]:3000
```

Beispiel: `http://192.168.1.100:3000`

## 💡 Anwendungsfälle

### Für Entwickler
- Code-Generierung und -Reviews
- Debugging-Hilfe
- Dokumentation schreiben
- API-Design

### Für Kreative
- Texte schreiben und überarbeiten
- Brainstorming
- Übersetzungen
- Geschichten entwickeln

### Für Analysten
- Dokumente zusammenfassen
- Daten analysieren
- Berichte erstellen
- Trends identifizieren

### Für Privatanwender
- Persönliche Assistenz
- Hausaufgabenhilfe
- Rezepte umwandeln
- Smart-Home-Skripte

## 🐛 Troubleshooting

### Langsame Antworten
- Kleineres Modell verwenden
- Kontextlänge reduzieren
- Andere Apps schließen
- Docker Ressourcen erhöhen

### Speicher voll
- Alte Modelle löschen: `ollama rm [model]`
- Docker aufräumen: `docker system prune`
- SSD-Speicher freiräumen (10-15% frei lassen)

### Modell lädt nicht
- Internet-Verbindung prüfen
- Ollama neu starten
- Download-Pfad prüfen: `~/.ollama`

### Docker startet nicht
- Docker Desktop neu installieren
- Systemstart abwarten
- Berechtigungen prüfen

## 📚 Ressourcen

- **Ollama Modellsuche:** https://ollama.com/search
- **Open WebUI Dokumentation:** https://github.com/open-webui/open-webui
- **Docker Desktop:** https://docker.com/products/docker-desktop
- **GPU Kompatibilitäts-Rechner:** Ollama GitHub Repository

## 🔐 Sicherheit & Datenschutz

✅ Alle Daten bleiben lokal auf deinem Mac
✅ Keine Verbindung zu externen Servern (außer beim Model-Download)
✅ Volle Kontrolle über Benutzerdaten
✅ Optional: HTTPS-Verschlüsselung für Netzwerkzugriff

## ⚠️ Wichtiger Haftungsausschluss

**NUTZUNG AUF EIGENE GEFAHR**

Diese Software wird **OHNE JEGLICHE GARANTIE** bereitgestellt. Der Autor übernimmt **KEINERLEI Haftung** für:

- ❌ Datenverlust oder Beschädigung
- ❌ Systemabstürze oder Instabilitäten
- ❌ Konfigurationsänderungen
- ❌ Jegliche direkten oder indirekten Schäden

**VOR DER INSTALLATION:**
1. ✅ Erstellen Sie ein **vollständiges Backup** Ihres Systems
2. ✅ Lesen Sie den vollständigen Haftungsausschluss: [`LICENSE_DISCLAIMER.txt`](LICENSE_DISCLAIMER.txt)
3. ✅ Akzeptieren Sie die Nutzung auf **eigene Verantwortung**

Bei der Installation werden Sie aufgefordert, den Haftungsausschluss zu akzeptieren.

## 🤝 Beitragen

Verbesserungsvorschläge, Bug-Reports und Pull Requests sind willkommen!

## 📄 Lizenz

Dieses Projekt basiert auf:
- **Ollama** (MIT License)
- **Open WebUI** (MIT License)
- **Docker** (Apache 2.0)

## ✨ Credits

Basierend auf dem heise-Artikel "Mac als lokales KI-System: So geht's" von Thomas Joos (12.11.2025)

---

**Viel Erfolg mit deinem lokalen KI-Server! 🚀**
