# Getting Started mit OllamaDeploy

Eine Schritt-für-Schritt-Anleitung zur Einrichtung deines lokalen KI-Systems.

## Inhaltsverzeichnis

1. [Erste Installation](#erste-installation)
2. [Ersten Chat starten](#ersten-chat-starten)
3. [Modelle verstehen](#modelle-verstehen)
4. [Best Practices](#best-practices)
5. [Troubleshooting](#troubleshooting)

## Erste Installation

### Schritt 1: Repository klonen

```bash
git clone https://github.com/cocoacastsplus/OllamaDeploy.git
cd OllamaDeploy
```

### Schritt 2: Setup ausführen

```bash
./scripts/setup.sh
```

Das Skript führt dich durch:
- ✅ System-Prüfung (RAM, Speicher, CPU)
- ✅ Ollama Installation
- ✅ Docker Desktop Installation
- ✅ Open WebUI Setup
- ✅ Erstes Modell herunterladen

### Schritt 3: Browser öffnen

Nach erfolgreicher Installation:

```
http://localhost:3000
```

## Ersten Chat starten

### 1. Admin-Account erstellen

Beim ersten Besuch von Open WebUI:

1. **Name** eingeben (z.B. "Max")
2. **E-Mail** eingeben (bleibt lokal, nur für Login)
3. **Passwort** wählen (mind. 8 Zeichen)
4. Klick auf "Administrator-Account erstellen"

### 2. Sprache auf Deutsch stellen

1. Klick auf **Benutzer-Icon** (oben rechts)
2. **Settings** → **General**
3. **Language** → "German (Deutsch)"
4. Seite neu laden

### 3. Erstes Modell auswählen

Im Chat-Fenster:

1. Klick auf **Modell-Auswahl** (oben, neben "Neue Unterhaltung")
2. Wähle dein heruntergeladenes Modell (z.B. "llama3.1:latest")
3. Klick auf "Als Standard festlegen"

### 4. Ersten Prompt senden

Teste die KI mit einer einfachen Frage:

```
Erkläre mir in 3 Sätzen, was ein Large Language Model ist.
```

## Modelle verstehen

### Parameter-Größen

| Größe | Parameter | RAM-Bedarf | Empfehlung |
|-------|-----------|------------|------------|
| **Klein** | 7-8B | 16 GB | Alltag, Texte |
| **Mittel** | 13-32B | 32 GB | Programmierung |
| **Groß** | 70B | 64 GB | Komplexe Analysen |
| **Sehr groß** | 671B | 128+ GB | Professionell |

### Empfohlene Starter-Modelle

#### Für 16 GB RAM
```bash
# LLaMA 3.1 - Vielseitig und zuverlässig
ollama pull llama3.1

# DeepSeek R1 7B - Schnell und effizient
ollama pull deepseek-r1:7b
```

#### Für 32 GB RAM
```bash
# Gemma 3 - Google's Modell mit guter Performance
ollama pull gemma3:12b

# DeepSeek R1 32B - Sehr gutes Reasoning
ollama pull deepseek-r1:32b
```

#### Für 64+ GB RAM
```bash
# LLaMA 3.3 70B - Eines der besten Open-Source-Modelle
ollama pull llama3.3:70b
```

### Modell-Typen

**Generalist-Modelle (LLaMA, Mistral)**
- Vielseitig einsetzbar
- Gute Balance zwischen Größe und Leistung
- Ideal für: Texte, Übersetzungen, allgemeine Fragen

**Reasoning-Modelle (DeepSeek-R1)**
- Spezialisiert auf logisches Denken
- Zeigt Denkprozesse
- Ideal für: Mathematik, Programmierung, Analysen

**Vision-Modelle (Gemma 3)**
- Können Bilder interpretieren
- Text- und Bild-Verständnis
- Ideal für: Bild-Analysen, OCR, visuelle Aufgaben

## Best Practices

### Prompts optimieren

#### ❌ Schlecht
```
Was ist das?
```

#### ✅ Gut
```
Analysiere das hochgeladene Bild und beschreibe:
1. Was ist darauf zu sehen?
2. Welche Objekte sind erkennbar?
3. Welche Farben dominieren?
```

### System-Prompts nutzen

Passe die KI an deine Bedürfnisse an:

**Für Programmierung:**
```
Du bist ein Senior-Entwickler mit Expertise in Python und JavaScript.
Antworte mit lauffähigem Code und erkläre deine Entscheidungen.
Verwende Best Practices und moderne Syntax.
```

**Für Texterstellung:**
```
Du bist ein professioneller Texter. Schreibe klare, prägnante
Texte im journalistischen Stil. Vermeide Füllwörter und
verwende aktive Formulierungen.
```

**Für Analysen:**
```
Du bist ein Datenanalyst. Analysiere objektiv und faktenbasiert.
Strukturiere Antworten mit:
1. Zusammenfassung
2. Detaillierte Analyse
3. Schlussfolgerungen
```

### Parameter-Einstellungen

| Aufgabe | Temperatur | Top K | Top P |
|---------|------------|-------|-------|
| **Code schreiben** | 0.2 | 40 | 0.85 |
| **Texte korrigieren** | 0.3 | 50 | 0.9 |
| **Kreatives Schreiben** | 0.8 | 100 | 0.95 |
| **Zusammenfassungen** | 0.2 | 40 | 0.85 |
| **Brainstorming** | 0.9 | 100 | 0.95 |

### Dokumente hochladen

Unterstützte Formate:
- 📄 PDF (.pdf)
- 📝 Text (.txt, .md)
- 📊 Tabellen (.csv, .xlsx)
- 🖼️ Bilder (.jpg, .png)

**Gute Prompts für Dokumente:**

```
Fasse das PDF in 5 Bullet Points zusammen
```

```
Erstelle aus der Tabelle eine Executive Summary
```

```
Extrahiere alle Daten aus dem Bild und formatiere sie als Tabelle
```

```
Analysiere den Vertrag und liste alle Fristen auf
```

### Mehrere Modelle vergleichen

1. Im Chat auf **"+"** neben Modell-Auswahl klicken
2. Weitere Modelle hinzufügen
3. Gleiche Frage an alle Modelle stellen
4. Antworten nebeneinander vergleichen

Ideal für:
- Qualitätsvergleiche
- Faktenchecks
- Stilvergleiche

### Unterhaltungen organisieren

**Ordner erstellen:**
1. Sidebar → "Unterhaltungen" → **+**
2. Ordner benennen (z.B. "Programmierung", "Texte")
3. Chats per Drag & Drop zuordnen

**Chats exportieren:**
1. Einstellungen → Unterhaltungen
2. "Unterhaltungen exportieren"
3. JSON-Datei speichern (inkl. hochgeladene Dateien)

**Chats archivieren:**
- Alte Chats aus Sidebar entfernen
- Bleiben durchsuchbar
- Über Menü wieder aktivierbar

## Troubleshooting

### Langsame Antworten

**Problem:** KI antwortet sehr langsam

**Lösungen:**
1. Kleineres Modell verwenden
2. Kontextlänge reduzieren (Einstellungen → Allgemein)
3. Andere Apps schließen
4. Docker mehr RAM zuweisen (Docker Desktop → Resources)

### Modell passt nicht in RAM

**Problem:** "Out of memory" Fehler

**Lösungen:**
1. Kleineres Modell wählen (7B statt 32B)
2. Andere Apps beenden
3. Mac neu starten (RAM freigeben)
4. Quantisiertes Modell verwenden

### Docker startet nicht

**Problem:** "Cannot connect to Docker daemon"

**Lösungen:**
1. Docker Desktop starten (Programme → Docker)
2. 30-60 Sekunden warten
3. Im Terminal prüfen: `docker info`
4. Bei Fehler: Docker neu installieren

### Modell lädt nicht herunter

**Problem:** Download bricht ab

**Lösungen:**
1. Internetverbindung prüfen
2. VPN deaktivieren (falls aktiv)
3. Speicherplatz prüfen: `df -h`
4. Ollama neu starten: `killall ollama`
5. Download wiederholen

### Halluzinationen

**Problem:** KI erfindet Fakten

**Lösungen:**
1. **Temperatur** auf 0.2-0.4 senken
2. **Präzisere Prompts** verwenden
3. **Dokumente hochladen** als Faktenbasis
4. **Größeres Modell** verwenden
5. **Websuche aktivieren** (Einstellungen → Websuche)

### Speicher voll

**Problem:** "No space left on device"

**Lösungen:**
```bash
# Ungenutzte Modelle löschen
ollama list
ollama rm [modell-name]

# Docker aufräumen
docker system prune -a

# Temporäre Dateien löschen
rm -rf ~/.ollama/tmp/*

# Speicher prüfen
df -h
```

### Container läuft nicht

**Problem:** Open WebUI nicht erreichbar

**Lösungen:**
```bash
# Status prüfen
docker ps -a

# Container starten
docker start open-webui

# Logs anzeigen
docker logs open-webui

# Neustart erzwingen
docker restart open-webui
```

## Weitere Hilfe

- 📖 [Vollständige Dokumentation](../README.md)
- 🔧 [Model-Empfehlungen](MODEL_RECOMMENDATIONS.md)
- ⚙️ [Konfiguration](CONFIGURATION.md)
- 🛠️ [Verwaltungsskript](../scripts/manage.sh)

---

**Viel Erfolg! Bei Fragen → [GitHub Issues](https://github.com/cocoacastsplus/OllamaDeploy/issues)**
