# Installation Guide

Vollständige Anleitung zur Installation von OllamaDeploy.

## 🚀 Quick Start (5 Minuten)

```bash
git clone https://github.com/cocoacastsplus/OllamaDeploy.git
cd OllamaDeploy
./install.sh --auto
```

**Fertig!** Öffne http://localhost:3000

---

## 📦 Installations-Methoden

### Methode 1: Vollautomatisch (Empfohlen)

**Für wen?** Nutzer die es einfach haben wollen

```bash
./install.sh --auto
```

**Was passiert:**
1. ✅ System wird geprüft (RAM, Speicher, CPU)
2. ✅ Homebrew wird installiert (falls nötig)
3. ✅ Ollama wird via Homebrew installiert
4. ✅ Docker Desktop wird heruntergeladen & installiert
5. ✅ Open WebUI Container wird erstellt
6. ✅ Standard-Modell (llama3.1) wird heruntergeladen
7. ✅ Browser öffnet sich automatisch

**Dauer:** ~10 Minuten (abhängig von Internet-Geschwindigkeit)

---

### Methode 2: Interaktiv

**Für wen?** Nutzer die mehr Kontrolle wollen

```bash
./install.sh
```

**Was passiert:**
- Wie Methode 1, aber mit Rückfragen
- Du wählst das Modell selbst
- Du bestätigst jeden Schritt
- Mehr Kontrolle über den Prozess

**Dauer:** ~10-15 Minuten

---

### Methode 3: Manuell

**Für wen?** Experten oder Debug-Zwecke

```bash
# Schritt für Schritt
./scripts/setup.sh     # Basis-Installation
./scripts/manage.sh    # Modelle verwalten
```

---

## 🎛️ Installations-Optionen

### Vollautomatisch ohne Modell

```bash
./install.sh --auto --skip-model
```

Installiert alles außer dem KI-Modell. Modell kannst du später laden:

```bash
ollama pull llama3.1
```

### Nur System-Check

```bash
./install.sh --help
```

Zeigt alle verfügbaren Optionen.

### Verbose-Modus (für Debugging)

```bash
./install.sh --verbose
```

Zeigt alle Befehle die ausgeführt werden.

---

## 📋 Was wird installiert?

### 1. Homebrew
- **Was:** Package Manager für macOS
- **Warum:** Einfachste Methode Ollama zu installieren
- **Speicher:** ~200 MB
- **Wird installiert falls:** Noch nicht vorhanden

### 2. Ollama
- **Was:** Runtime für LLMs
- **Warum:** Kern des Systems
- **Speicher:** ~100 MB (App) + Modelle
- **Installation:** Via Homebrew (`brew install ollama`)

### 3. Docker Desktop
- **Was:** Container-Platform
- **Warum:** Für Open WebUI
- **Speicher:** ~500 MB
- **Installation:** Automatischer Download + Install

### 4. Open WebUI
- **Was:** Web-Interface (wie ChatGPT)
- **Warum:** Benutzerfreundliche Bedienung
- **Speicher:** ~300 MB Docker Image
- **Installation:** Docker Container

### 5. KI-Modell (Optional)
- **Was:** Das eigentliche LLM
- **Welche:** Standard ist llama3.1 (5 GB)
- **Speicher:** 5-400 GB je nach Modell
- **Installation:** Via Ollama

**Gesamtspeicher:** ~6-7 GB für Basis-Installation

---

## ✅ System-Anforderungen

### Geprüft beim Start

Das Install-Script prüft automatisch:

#### Betriebssystem
- ✅ macOS 11 Big Sur oder neuer
- ⚠️ Bei älteren Versionen: Warnung

#### Prozessor
- ✅ **Optimal:** Apple Silicon (M1/M2/M3/M4)
- ⚠️ **Funktioniert:** Intel (deutlich langsamer)

#### Arbeitsspeicher
- ❌ **< 16 GB:** Nicht empfohlen
- ✅ **16 GB:** Gut für kleine Modelle
- ✅ **32 GB:** Sehr gut
- 🚀 **64+ GB:** Optimal

#### Speicherplatz
- ❌ **< 50 GB:** Zu wenig
- ✅ **50-100 GB:** Ausreichend
- 🚀 **100+ GB:** Optimal für mehrere Modelle

#### Internet
- ✅ Aktive Verbindung nötig (für Downloads)
- ~6 GB Downloads (Ollama + Docker + Modell)

---

## 🔧 Schritt-für-Schritt Ablauf

### Phase 1: Vorbereitung (1-2 Min)

```
[ℹ] Prüfe Betriebssystem...
[✓] macOS 14.1.0 erkannt

[ℹ] Prüfe CPU-Architektur...
[✓] Apple Silicon (M1/M2/M3/M4) erkannt - Optimal!

[ℹ] Prüfe Arbeitsspeicher...
[ℹ] Installierter RAM: 32 GB
[✓] 32 GB RAM - Sehr gut für große Modelle!

[ℹ] Prüfe Speicherplatz...
[ℹ] Freier Speicher: 156 GB
[✓] Ausreichend Speicherplatz verfügbar

[ℹ] Prüfe Internetverbindung...
[✓] Internetverbindung verfügbar
```

### Phase 2: Homebrew (2-3 Min)

```
→ Installiere Homebrew...

[ℹ] Homebrew wird installiert...
[ℹ] Dies kann einige Minuten dauern...

[✓] Homebrew erfolgreich installiert!
[✓] Homebrew aktualisiert
```

### Phase 3: Ollama (2-3 Min)

```
→ Installiere Ollama...

[ℹ] Installiere Ollama via Homebrew...

[✓] Ollama erfolgreich installiert!
[✓] Ollama Service läuft
```

### Phase 4: Docker Desktop (3-4 Min)

```
→ Installiere Docker Desktop...

[ℹ] Lade Docker Desktop herunter...
[████████████████████] 100%

[✓] Download abgeschlossen
[✓] Docker Desktop installiert!

[ℹ] Warte auf Docker (kann 30-60 Sekunden dauern)...
[████████████████████] 100% Docker startet...

[✓] Docker ist bereit!
```

### Phase 5: Open WebUI (1-2 Min)

```
→ Installiere Open WebUI...

[ℹ] Lade Open WebUI Image...
[ℹ] Erstelle Open WebUI Container...

[✓] Open WebUI ist bereit!
```

### Phase 6: Modell-Download (5-10 Min)

```
→ Lade KI-Modell herunter...

Empfohlene Starter-Modelle:
  1) llama3.1        (~5 GB) - Empfohlen für 16+ GB RAM
  2) deepseek-r1:7b  (~5 GB) - Für Programmierung
  3) gemma3:12b      (~8 GB) - Google Modell
  4) Überspringen

Wähle eine Option (1-4) [1]: 1

[ℹ] Lade Modell: llama3.1
[ℹ] Dies kann 5-10 Minuten dauern...

[✓] Modell llama3.1 erfolgreich heruntergeladen!
```

### Phase 7: Abschluss

```
╔════════════════════════════════════════╗
║                                        ║
║  ✨ Installation erfolgreich! ✨      ║
║                                        ║
╚════════════════════════════════════════╝

[✓] Ollama läuft und ist bereit
[✓] Docker Desktop läuft
[✓] Open WebUI ist verfügbar

→ Nächste Schritte:

  1. Öffne Open WebUI im Browser:
     http://localhost:3000

  2. Erstelle einen Administrator-Account

  3. Lade weitere Modelle (optional):
     ollama pull deepseek-r1:32b
     ollama pull gemma3:12b

  4. Verwaltungs-Tools:
     ./scripts/manage.sh  - System verwalten
     ./scripts/update.sh  - Updates installieren

Viel Spaß mit deinem lokalen KI-System! 🚀
```

---

## 🐛 Troubleshooting

### Installation bricht ab

**Problem:** Script stoppt mit Fehler

**Lösung:**
```bash
# Verbose-Modus für Details
./install.sh --verbose

# Oder Log-Datei prüfen
cat /tmp/ollamadeploy-install/*.log
```

### Homebrew Installation schlägt fehl

**Problem:** "Failed to install Homebrew"

**Lösung:**
```bash
# Homebrew manuell installieren
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"

# Dann erneut versuchen
./install.sh
```

### Docker Download zu langsam

**Problem:** Download dauert sehr lange

**Lösung:**
```bash
# Docker Desktop manuell herunterladen
# https://www.docker.com/products/docker-desktop

# Dann installieren und Script ohne Docker ausführen
./install.sh --skip-docker  # (Option nicht implementiert)
```

### Nicht genug Speicherplatz

**Problem:** "No space left on device"

**Lösung:**
```bash
# Speicher aufräumen
# Alte Dateien löschen
# Dann ohne Modell installieren

./install.sh --auto --skip-model
```

### Installation bei < 16 GB RAM

**Problem:** Script warnt vor zu wenig RAM

**Lösung:**
```bash
# Trotzdem installieren
./install.sh --auto

# Nur kleine Modelle verwenden
ollama pull deepseek-r1:1.5b  # Nur 1.1 GB
```

---

## 🔄 Re-Installation

### Saubere Neu-Installation

```bash
# 1. Alles deinstallieren
./uninstall.sh --force

# 2. Neu installieren
./install.sh --auto
```

### Update statt Neuinstallation

```bash
# Nur Updates installieren
./scripts/update.sh
```

---

## 📝 Manuelle Installation

Falls das Automatik-Script nicht funktioniert:

### 1. Homebrew

```bash
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
```

### 2. Ollama

```bash
brew install ollama
brew services start ollama
```

### 3. Docker Desktop

1. Downloaden: https://www.docker.com/products/docker-desktop
2. DMG öffnen und Docker.app nach /Applications kopieren
3. Docker.app starten

### 4. Open WebUI

```bash
docker run -d \
  -p 3000:8080 \
  --add-host=host.docker.internal:host-gateway \
  -v open-webui:/app/backend/data \
  --name open-webui \
  --restart always \
  ghcr.io/open-webui/open-webui:main
```

### 5. Modell

```bash
ollama pull llama3.1
```

---

## ✨ Nach der Installation

### Zugriff auf Open WebUI

**Lokal:**
```
http://localhost:3000
```

**Im Netzwerk:**
```
http://[DEINE-MAC-IP]:3000

# IP herausfinden:
ifconfig | grep "inet " | grep -v 127.0.0.1
```

### Erste Schritte

1. **Admin-Account erstellen**
   - Name eingeben
   - E-Mail (bleibt lokal)
   - Passwort

2. **Sprache umstellen**
   - Einstellungen → General
   - Language → Deutsch

3. **Erstes Modell wählen**
   - Modell-Dropdown
   - llama3.1 auswählen

4. **Los geht's!**
   - Prompt eingeben
   - Enter drücken

---

## 📚 Weiterführende Dokumentation

- [Getting Started](GETTING_STARTED.md) - Ausführliche Anleitung
- [Model Recommendations](MODEL_RECOMMENDATIONS.md) - Welches Modell?
- [README](../README.md) - Projekt-Übersicht

---

**Viel Erfolg! Bei Problemen → [GitHub Issues](https://github.com/cocoacastsplus/OllamaDeploy/issues)**
