# Modell-Empfehlungen für OllamaDeploy

Eine detaillierte Übersicht aller verfügbaren KI-Modelle mit Empfehlungen für verschiedene Anwendungsfälle.

## Inhaltsverzeichnis

1. [Modell-Übersicht](#modell-übersicht)
2. [Nach Anwendungsfall](#nach-anwendungsfall)
3. [Nach Hardware](#nach-hardware)
4. [Performance-Vergleich](#performance-vergleich)

## Modell-Übersicht

### LLaMA 3.1 / 3.3 (Meta)

**Hersteller:** Meta (Facebook)
**Lizenz:** Llama Community License
**Stärken:** Vielseitig, zuverlässig, große Community

| Version | Parameter | Größe | Min. RAM | Empfohlen für |
|---------|-----------|-------|----------|---------------|
| llama3.1 | 8B | 4.7 GB | 16 GB | Alltag, Texte |
| llama3.2 | 3B | 2 GB | 8 GB | Leichte Aufgaben |
| llama3.3:70b | 70B | 43 GB | 64 GB | Komplexe Analysen |

**Installation:**
```bash
ollama pull llama3.1
ollama pull llama3.3:70b
```

**Beste Einstellungen:**
- Temperatur: 0.4
- Top P: 0.9
- Top K: 50

**Ideal für:**
- Allgemeine Textgenerierung
- Übersetzungen
- Zusammenfassungen
- E-Mails schreiben
- Kundenservice

---

### DeepSeek-R1 (DeepSeek AI)

**Hersteller:** DeepSeek AI (China)
**Lizenz:** MIT License
**Stärken:** Reasoning, Mathematik, Programmierung

| Version | Parameter | Größe | Min. RAM | Empfohlen für |
|---------|-----------|-------|----------|---------------|
| deepseek-r1:1.5b | 1.5B | 1.1 GB | 8 GB | Schnelle Tests |
| deepseek-r1:7b | 7B | 4.7 GB | 16 GB | Standard |
| deepseek-r1:8b | 8B | 4.9 GB | 16 GB | Balanced |
| deepseek-r1:14b | 14B | 9 GB | 24 GB | Performance |
| deepseek-r1:32b | 32B | 20 GB | 32 GB | Profi |
| deepseek-r1:70b | 70B | 43 GB | 64 GB | High-End |
| deepseek-r1:671b | 671B | 404 GB | 512 GB | Maximum |

**Installation:**
```bash
# Empfehlung für Start
ollama pull deepseek-r1:8b

# Für mehr RAM
ollama pull deepseek-r1:32b
```

**Beste Einstellungen:**
- Temperatur: 0.2-0.3 (für Logik)
- Top P: 0.85
- Top K: 40

**Ideal für:**
- Programmierung
- Mathematik
- Logische Rätsel
- Code-Reviews
- Debugging
- Algorithmisches Denken

**Besonderheit:**
Zeigt Denkprozess (Chain-of-Thought), ideal zum Nachvollziehen von Lösungswegen.

---

### Gemma 3 (Google)

**Hersteller:** Google DeepMind
**Lizenz:** Gemma License
**Stärken:** Vision, Multimodal, Schnell

| Version | Parameter | Größe | Min. RAM | Empfohlen für |
|---------|-----------|-------|----------|---------------|
| gemma3:2b | 2B | 1.6 GB | 8 GB | Mobile, Tests |
| gemma3:9b | 9B | 5.8 GB | 16 GB | Standard |
| gemma3:12b | 12B | 7.8 GB | 24 GB | Empfohlen |
| gemma3:27b | 27B | 17 GB | 32 GB | High Performance |

**Installation:**
```bash
ollama pull gemma3:12b
```

**Beste Einstellungen:**
- Temperatur: 0.5
- Top P: 0.9
- Top K: 60

**Ideal für:**
- Bildanalyse
- OCR (Text aus Bildern)
- Diagramm-Interpretation
- Multimodale Aufgaben
- Schnelle Antworten

---

### Mistral (Mistral AI)

**Hersteller:** Mistral AI (Frankreich)
**Lizenz:** Apache 2.0
**Stärken:** Effizienz, Mehrsprachigkeit

| Version | Parameter | Größe | Min. RAM | Empfohlen für |
|---------|-----------|-------|----------|---------------|
| mistral | 7B | 4.1 GB | 16 GB | Standard |
| mistral-nemo | 12B | 7 GB | 24 GB | Balanced |
| mistral-large | 123B | 75 GB | 96 GB | Enterprise |

**Installation:**
```bash
ollama pull mistral
ollama pull mistral-nemo
```

**Beste Einstellungen:**
- Temperatur: 0.4
- Top P: 0.9
- Top K: 55

**Ideal für:**
- Mehrsprachige Texte
- Europäische Sprachen
- Lange Kontexte
- Dokumentenanalyse

---

### Code LLaMA (Meta)

**Hersteller:** Meta
**Lizenz:** Llama Community License
**Stärken:** Programmierung, Code-Generierung

| Version | Parameter | Größe | Min. RAM | Empfohlen für |
|---------|-----------|-------|----------|---------------|
| codellama | 7B | 3.8 GB | 16 GB | Code-Snippets |
| codellama:13b | 13B | 7.3 GB | 24 GB | Projekte |
| codellama:34b | 34B | 19 GB | 32 GB | Enterprise |

**Installation:**
```bash
ollama pull codellama
ollama pull codellama:13b
```

**Beste Einstellungen:**
- Temperatur: 0.2
- Top P: 0.85
- Top K: 40

**Ideal für:**
- Code-Generierung
- Refactoring
- Bug-Fixes
- Code-Erklärungen
- Dokumentation

---

## Nach Anwendungsfall

### Programmierung

**🥇 Best:** DeepSeek-R1:32b
- Exzellentes Reasoning
- Code-Verständnis
- Debugging-Fähigkeiten

**🥈 Alternative:** Code LLaMA:13b
- Spezialisiert auf Code
- Schneller
- Weniger RAM

**🥉 Budget:** DeepSeek-R1:8b
- Gute Balance
- 16 GB RAM ausreichend

```bash
ollama pull deepseek-r1:32b
```

**System Prompt:**
```
Du bist ein Senior-Entwickler. Schreibe sauberen, gut dokumentierten
Code mit Best Practices. Erkläre komplexe Konzepte einfach.
```

---

### Texterstellung & Kreatives Schreiben

**🥇 Best:** LLaMA 3.3:70b
- Natürliche Sprache
- Kreativität
- Stilsicherheit

**🥈 Alternative:** LLaMA 3.1
- Sehr gut für Alltag
- Schneller
- Weniger RAM

**🥉 Budget:** Mistral
- Effizient
- Mehrsprachig

```bash
ollama pull llama3.3:70b
```

**System Prompt:**
```
Du bist ein professioneller Autor. Schreibe kreativ, prägnant und
fesselnd. Verwende lebendige Beschreibungen und abwechslungsreiche
Satzstrukturen.
```

**Einstellungen:**
- Temperatur: 0.7-0.9
- Frequenzstrafe: 0.3

---

### Bildanalyse & OCR

**🥇 Best:** Gemma 3:27b
- Multimodal
- Sehr gute Bilderkennung
- Detailgenau

**🥈 Alternative:** Gemma 3:12b
- Gute Balance
- Schneller

```bash
ollama pull gemma3:27b
```

**Beispiel-Prompts:**
```
Beschreibe das Bild im Detail und erkenne alle Texte
```

```
Extrahiere alle Zahlen und Daten aus dem Dokument
```

---

### Dokumentenanalyse & Zusammenfassungen

**🥇 Best:** LLaMA 3.3:70b
- Lange Kontexte
- Präzise Zusammenfassungen
- Strukturierte Ausgaben

**🥈 Alternative:** Mistral-Nemo
- Spezialisiert auf Dokumente
- Effizienter

```bash
ollama pull llama3.3:70b
```

**System Prompt:**
```
Du bist ein Analyst. Fasse Dokumente strukturiert zusammen:
1. Kernaussagen (3-5 Punkte)
2. Details
3. Wichtige Zahlen/Daten
4. Offene Fragen
```

---

### Mathematik & Logik

**🥇 Best:** DeepSeek-R1:70b
- Bestes Reasoning
- Zeigt Lösungswege
- Hochpräzise

**🥈 Alternative:** DeepSeek-R1:32b
- Sehr gut
- Weniger RAM

```bash
ollama pull deepseek-r1:70b
```

**Einstellungen:**
- Temperatur: 0.1-0.2
- Top P: 0.8

---

### Übersetzungen

**🥇 Best:** Mistral-Large
- Mehrsprachig
- Kulturelle Nuancen
- EU-Sprachen

**🥈 Alternative:** LLaMA 3.1
- Vielseitig
- Gute Qualität

```bash
ollama pull mistral-large
```

**Prompt-Template:**
```
Übersetze folgenden Text von [Ausgangssprache] nach [Zielsprache].
Behalte den Ton und Stil bei. Achte auf kulturelle Anpassungen:

[TEXT]
```

---

## Nach Hardware

### 8 GB RAM
⚠️ **Nicht empfohlen** für produktive Nutzung

Mögliche Modelle:
- `gemma3:2b` (1.6 GB)
- `llama3.2` (2 GB)
- `deepseek-r1:1.5b` (1.1 GB)

**Einschränkungen:**
- Sehr langsam
- Begrenzte Fähigkeiten
- Nur für Tests

---

### 16 GB RAM
✅ **Empfohlen** für Einsteiger

**Top-Modelle:**
```bash
# Allround
ollama pull llama3.1

# Programmierung
ollama pull deepseek-r1:8b

# Schnell & effizient
ollama pull mistral
```

**Gleichzeitig nutzbar:**
- 1 Modell mit 8B Parametern
- Oder 2 Modelle mit je 3-4B

---

### 32 GB RAM
✅ **Optimal** für fortgeschrittene Nutzung

**Top-Modelle:**
```bash
# Beste Balance
ollama pull deepseek-r1:32b

# Vielseitig
ollama pull gemma3:27b

# Für Code
ollama pull codellama:34b
```

**Gleichzeitig nutzbar:**
- 1 Modell mit 32B Parametern
- Oder 2-3 kleinere Modelle

---

### 64 GB RAM
🚀 **Premium** für professionelle Anwendungen

**Top-Modelle:**
```bash
# Beste Qualität
ollama pull llama3.3:70b

# Reasoning
ollama pull deepseek-r1:70b

# Mehrere parallel
ollama pull llama3.1
ollama pull deepseek-r1:32b
ollama pull gemma3:27b
```

**Gleichzeitig nutzbar:**
- 1 Modell mit 70B
- Oder mehrere kleinere parallel

---

### 128+ GB RAM
🏆 **Maximum** für Enterprise

**Top-Modelle:**
```bash
# Maximum Performance
ollama pull mistral-large

# Für sehr komplexe Aufgaben
ollama pull deepseek-r1:671b (nur mit 512+ GB)
```

---

## Performance-Vergleich

### Geschwindigkeit (Tokens/Sekunde auf M3 Max, 64GB)

| Modell | Parameter | Tokens/s |
|--------|-----------|----------|
| LLaMA 3.1 | 8B | ~45 |
| DeepSeek-R1 | 8B | ~40 |
| Gemma 3 | 12B | ~35 |
| DeepSeek-R1 | 32B | ~18 |
| LLaMA 3.3 | 70B | ~8 |

### Qualitätsbewertung (1-10)

| Modell | Code | Text | Reasoning | Mehrsprachig |
|--------|------|------|-----------|--------------|
| DeepSeek-R1:32b | 9 | 7 | 10 | 7 |
| LLaMA 3.3:70b | 8 | 10 | 8 | 8 |
| Gemma 3:27b | 7 | 8 | 7 | 7 |
| Code LLaMA:13b | 10 | 5 | 6 | 5 |
| Mistral | 7 | 8 | 7 | 9 |

---

## Schnell-Empfehlungen

### "Ich will einfach loslegen"
```bash
ollama pull llama3.1
```

### "Ich programmiere viel"
```bash
ollama pull deepseek-r1:32b
```

### "Ich arbeite mit Bildern"
```bash
ollama pull gemma3:12b
```

### "Ich brauche das Beste"
```bash
ollama pull llama3.3:70b
ollama pull deepseek-r1:70b
```

---

**Weitere Modelle findest du auf:** https://ollama.com/search
