#!/bin/bash

###############################################################################
# OllamaDeploy Quick Start
# Schneller Einstieg für die wichtigsten Befehle
###############################################################################

# Farben
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${BLUE}"
echo "╔════════════════════════════════════════════════════════╗"
echo "║         OllamaDeploy Quick Start                       ║"
echo "╚════════════════════════════════════════════════════════╝"
echo -e "${NC}\n"

echo -e "${YELLOW}Häufige Befehle:${NC}\n"

echo -e "${GREEN}1. Open WebUI öffnen${NC}"
echo "   Browser: http://localhost:3000"
echo "   Befehl:  open http://localhost:3000"
echo ""

echo -e "${GREEN}2. Modelle verwalten${NC}"
echo "   Liste:      ollama list"
echo "   Download:   ollama pull llama3.1"
echo "   Löschen:    ollama rm llama3.1"
echo "   Terminal:   ollama run llama3.1"
echo ""

echo -e "${GREEN}3. Container verwalten${NC}"
echo "   Status:     docker ps"
echo "   Starten:    docker start open-webui"
echo "   Stoppen:    docker stop open-webui"
echo "   Neustarten: docker restart open-webui"
echo "   Logs:       docker logs open-webui"
echo ""

echo -e "${GREEN}4. System-Info${NC}"
echo "   RAM:        sysctl hw.memsize"
echo "   Speicher:   df -h /"
echo "   Docker:     docker system df"
echo "   Modelle:    du -sh ~/.ollama"
echo ""

echo -e "${GREEN}5. Verwaltungsskripte${NC}"
echo "   Management: ./scripts/manage.sh"
echo "   Update:     ./scripts/update.sh"
echo "   Setup:      ./scripts/setup.sh"
echo ""

echo -e "${YELLOW}Quick Actions:${NC}\n"

echo "Was möchtest du tun?"
echo ""
echo "1) Open WebUI öffnen"
echo "2) Verwaltungs-Tool starten"
echo "3) System-Status anzeigen"
echo "4) Neues Modell herunterladen"
echo "5) Beenden"
echo ""
read -p "Wähle eine Option (1-5): " -n 1 -r
echo ""

case $REPLY in
    1)
        echo -e "${BLUE}[ℹ]${NC} Öffne Open WebUI..."
        open http://localhost:3000
        ;;
    2)
        echo -e "${BLUE}[ℹ]${NC} Starte Verwaltungs-Tool..."
        ./scripts/manage.sh
        ;;
    3)
        echo -e "${BLUE}[ℹ]${NC} System-Status:"
        echo ""
        echo -e "${YELLOW}=== Ollama ===${NC}"
        ollama list
        echo ""
        echo -e "${YELLOW}=== Docker ===${NC}"
        docker ps --format "table {{.Names}}\t{{.Status}}\t{{.Ports}}"
        echo ""
        echo -e "${YELLOW}=== Speicher ===${NC}"
        df -h / | tail -1
        echo ""
        ;;
    4)
        echo -e "${BLUE}[ℹ]${NC} Beliebte Modelle:"
        echo "  • llama3.1 (5 GB)"
        echo "  • deepseek-r1:8b (5 GB)"
        echo "  • gemma3:12b (8 GB)"
        echo ""
        read -p "Modell-Name: " MODEL_NAME
        if [ ! -z "$MODEL_NAME" ]; then
            ollama pull "$MODEL_NAME"
        fi
        ;;
    5)
        echo -e "${BLUE}[ℹ]${NC} Tschüss!"
        exit 0
        ;;
    *)
        echo -e "${BLUE}[ℹ]${NC} Keine Aktion gewählt"
        ;;
esac
